#if !defined( _SPOTLIGHTS_FXH )
#define _SPOTLIGHTS_FXH

//---------------------------------------------------------------------------------
//
// Macros and definitions for spot lighting.
//

#define DECLARE_SPOT_PARAMS( __count__ )							\
float3 lightPosition##__count__ : lightPosition				\
<																											\
	bool appEdit = false;																\
>;																										\
float3 lightDirection##__count__ : lightDirection			\
<																											\
	bool appEdit = false;																\
>;																										\
float4 lightColour##__count__ : lightColour						\
<																											\
	bool appEdit = false;																\
>;																										\
float lightAttenuation##__count__ : lightAttenuation	\
<																											\
	bool appEdit = false;																\
>;																										\
float2 lightAngle##__count__ : lightAngle							\
<																											\
	bool appEdit = false;																\
>;

#define DECLARE_SPOT_INTERPOLATORS( __index__, __count__ )


#define DO_VS_SPOT_LIGHTING_SETUP


#define DO_VS_SPOT_LIGHTING_CALCULATIONS( __count__ )


#if defined( USE_TRANSMISSIVE_LIGHTING )

#define DO_PS_SPOT_LIGHTING_SETUP	\
	LPFLOAT3 PSSPOT_lightDir;				\
	LPFLOAT3 PSSPOT_lightVector;		\
	LPFLOAT PSSPOT_diffuseLevel;		\
	LPFLOAT PSSPOT_transLevel;

#else

#define DO_PS_SPOT_LIGHTING_SETUP	\
	LPFLOAT3 PSSPOT_lightDir;				\
	LPFLOAT3 PSSPOT_lightVector;		\
	LPFLOAT PSSPOT_diffuseLevel;

#endif


#if defined( USE_WARD_ANISOTROPIC_SPECULAR )

//
// Ward-style anisotropic lighting version
//
#define DO_PS_SPOT_LIGHTING_CALCULATIONS( __accumulator__, __count__ )																\
	/* Calculate light vector */																																				\
	PSSPOT_lightVector = lightPosition##__count__ - _input.worldPos;																		\
																																																			\
	/* Calculate light direction */																																			\
	PSSPOT_lightDir = lightDirection##__count__;																												\
																																																			\
	/* Calculate light attenuation */																																		\
	PSL_attenuation *= CalculateSpotLightAttenuation( PSSPOT_lightVector,																\
																										PSSPOT_lightDir,																	\
																										lightAttenuation##__count__,											\
																										lightAngle##__count__ );													\
																																																			\
	/* Calculate diffuse colour and add to accumulator */																								\
	PSSPOT_lightVector = normalize( PSSPOT_lightVector );																								\
																																																			\
	PSSPOT_diffuseLevel = CalculateDiffuseLighting( normal, PSSPOT_lightVector );												\
	__accumulator__ += diffuseTexColour * max( PSSPOT_diffuseLevel, 0.0f ) *														\
										 lightColour##__count__ * PSL_attenuation;																				\
																																																			\
	/* If the fragment faces the light source */																												\
	if ( PSSPOT_diffuseLevel > Rv( 0.0 ) )																															\
	{																																																		\
		/* Calculate specular colour and add to diffuse	*/																								\
		__accumulator__ += specularTexColour *																														\
											 CalculateWardSpecularLighting( normal, perturbedUAxis, perturbedVAxis, alphaXValue, alphaYValue, PSSPOT_lightVector, eye ) *	\
											 lightColour##__count__ * globalSpecularFactorValue * PSL_attenuation;								\
	}

#elif defined( USE_TRANSMISSIVE_LIGHTING )

//
// Blinn-style + transmissive lighting version
//
#define DO_PS_SPOT_LIGHTING_CALCULATIONS( __accumulator__, __count__ )																\
	/* Calculate light vector */																																				\
	PSSPOT_lightVector = lightPosition##__count__ - _input.worldPos;																		\
																																																			\
	/* Calculate light direction */																																			\
	PSSPOT_lightDir = lightDirection##__count__;																												\
																																																			\
	/* Calculate light attenuation */																																		\
	PSL_attenuation *= CalculateSpotLightAttenuation( PSSPOT_lightVector,																\
																										PSSPOT_lightDir,																	\
																										lightAttenuation##__count__,											\
																										lightAngle##__count__ );													\
																																																			\
	/* Calculate diffuse colour and add to accumulator */																								\
	PSSPOT_lightVector = normalize( PSSPOT_lightVector );																								\
																																																			\
	PSSPOT_diffuseLevel = CalculateDiffuseLighting( normal, PSSPOT_lightVector );												\
	__accumulator__ += diffuseTexColour * max( PSSPOT_diffuseLevel, 0.0f ) *														\
										 lightColour##__count__ * PSL_attenuation;																				\
																																																			\
	PSSPOT_transLevel = CalculateDiffuseLighting( -normal, PSSPOT_lightVector );												\
	__accumulator__ += transmissiveTexColour * max( PSSPOT_transLevel, 0.0f ) *													\
										 lightColour##__count__ * PSL_attenuation;																				\
																																																			\
	/* If the fragment faces the light source */																												\
	if ( PSSPOT_diffuseLevel > Rv( 0.0 ) )																															\
	{																																																		\
		/* Calculate specular colour and add to diffuse	*/																								\
		float specularPower = lerp( minSpecPowerValue, maxSpecPowerValue, specularTexColour.a );										\
		__accumulator__ += specularTexColour *																														\
											 CalculateSpecularLighting( normal,																							\
																									PSSPOT_lightVector,																	\
																									eye,																								\
																									specularPower ) *																		\
											 lightColour##__count__ *																												\
											 globalSpecularFactorValue *																													\
											 PSL_attenuation;																																\
	}

#else

//
// Blinn-style lighting version
//
#define DO_PS_SPOT_LIGHTING_CALCULATIONS( __accumulator__, __count__ )																\
	/* Calculate light vector */																																				\
	PSSPOT_lightVector = lightPosition##__count__ - _input.worldPos;																		\
																																																			\
	/* Calculate light direction */																																			\
	PSSPOT_lightDir = lightDirection##__count__;																												\
																																																			\
	/* Calculate light attenuation */																																		\
	PSL_attenuation *= CalculateSpotLightAttenuation( PSSPOT_lightVector,																\
																										PSSPOT_lightDir,																	\
																										lightAttenuation##__count__,											\
																										lightAngle##__count__ );													\
																																																			\
	/* Calculate diffuse colour and add to accumulator */																								\
	PSSPOT_lightVector = normalize( PSSPOT_lightVector );																								\
																																																			\
	PSSPOT_diffuseLevel = CalculateDiffuseLighting( normal, PSSPOT_lightVector );												\
	__accumulator__ += diffuseTexColour * max( PSSPOT_diffuseLevel, 0.0f ) *														\
										 lightColour##__count__ * PSL_attenuation;																				\
																																																			\
	/* If the fragment faces the light source */																												\
	if ( PSSPOT_diffuseLevel > Rv( 0.0 ) )																															\
	{																																																		\
		/* Calculate specular colour and add to diffuse	*/																								\
		float specularPower = lerp( minSpecPowerValue, maxSpecPowerValue, specularTexColour.a );										\
		__accumulator__ += specularTexColour *																														\
											 CalculateSpecularLighting( normal,																							\
																									PSSPOT_lightVector,																	\
																									eye,																								\
																									specularPower ) *																		\
											 lightColour##__count__ *																												\
											 globalSpecularFactorValue *																													\
											 PSL_attenuation;																																\
	}

#endif	// defined( USE_WARD_ANISOTROPIC_SPECULAR )

#endif	// !defined( _SPOTLIGHTS_FXH )
